/****************************************************
 * Adapted from oscP5sendreceive by andreas schlegel
 * oscP5 website at http://www.sojamo.de/oscP5
 *
 * -Expects data sent from the "faceOSC" app, sending: 
 * AddrPattern "/gesture/mouth/height" with a float message 
 */

import oscP5.*;
import netP5.*;
//-------------- Global Variables defined at top --------------------
 int messgRec;    //-- Create integer variable for notifications from OSC
 float oscValue1; //-- Create float variable for data in osc Message
 OscP5 oscP5;     //-- Create instance of OscP5 software object
 int mappedSer;           // Variable for scaled (mapped) value
 int numFrames = 13;      // The number of frames in the animation
 PImage[] images = new PImage[numFrames];

  void setup() {
    frameRate(30);
    size(793, 598);
    background(0, 0, 0);   // color (r, g, b)
    // The nf() command does number formatting, which will
    // ensure that the number is (in this case) 2 digits.
    for (int i = 0; i < numFrames; i++) {
      String imageName = "sloth" + nf(i, 2) + ".jpg";
      images[i] = loadImage(imageName);
       }
    smooth();
  /* start oscP5, listening for incoming messages at port 8800 */
  oscP5 = new OscP5(this, 8338); //-- Create instance of OscP5 called "oscP5"
   } 
 
// draw listens to serial port, calls serialEvent, draws   
  void draw() {  
    background(0, 0, 0);          // clear the screen
    fill(90, 100);                    // Set the gray value and alpha of the Rectangle 
    oscValue1 = constrain(oscValue1, 0, 7);
    mappedSer = int(map(oscValue1, 0, 7, 0, 12));
    fill(250);                       // Set the gray value and alpha of the letters 
    image(images[mappedSer], 0, 0);     
  }
  
/* incoming osc message are forwarded to the oscEvent method. */
void oscEvent(OscMessage theOscMessage) {
   if(theOscMessage.checkAddrPattern("/gesture/mouth/height")==true) {
 oscValue1 = theOscMessage.get(0).floatValue(); //-- Get float, if sent in message
 println("Value received: " + oscValue1);
  }
}
