/****************************************************
 * oscP5sendreceive by andreas schlegel
 * example shows how to send and receive osc messages.
 * oscP5 website at http://www.sojamo.de/oscP5
 *
 * -Expects data sent from the "faceOSC" app, sending: 
 * AddrPattern "/gesture/mouth/height" with a float message 
 */
 
import oscP5.*;
import netP5.*;
//-------------- Global Variables defined at top --------------------
int messgRec;    //-- Create integer variable for notifications from OSC
float oscValue1; //-- Create float variable for data in osc Message
OscP5 oscP5;     //-- Create instance of OscP5 software object
 
void setup() {
  size(400,400);
  frameRate(25);
  /* start oscP5, listening for incoming messages at port 8800 */
  oscP5 = new OscP5(this, 8338); //-- Create instance of OscP5 called "oscP5"
}

void draw() { 
    background(oscValue1 * 40); 
}

/* incoming osc message are forwarded to the oscEvent method. */
void oscEvent(OscMessage theOscMessage) {
   if(theOscMessage.checkAddrPattern("/gesture/mouth/height")==true) {
 oscValue1 = theOscMessage.get(0).floatValue(); //-- Get float, if sent in message
 println("Value received: " + oscValue1);
  }
}
