/**
 * Mixture Grid  
 * modified from an example by Simon Greenwold. 
 * multi-data serial addition by Dana Moser
 * 
 * Display a 2D grid of boxes with three different kinds of lights. 
 */
 import processing.serial.*;
 Serial myPort;
 float data1;
 float data2;
 String serialString;

void setup() {
  size(1280, 800, P3D);
  noStroke();
  println(Serial.list());   // Diagnostic: gives list of ports
  myPort = new Serial(this, Serial.list()[2], 9600); //-- Change to your port number
}

void draw() {
  defineLights();
  background(0);
  
  for (int x = 0; x <= width; x += 60) {
    for (int y = 0; y <= height; y += 60) {
      pushMatrix();
      translate(x, y);
      rotateY(map(data1, 0, width, 0, PI));
      rotateX(map(data2, 0, height, 0, PI));
      box(90);
      popMatrix();
    }
  }
}

void defineLights() {
  // Orange point light on the right
  pointLight(150, 100, 0,   // Color
             200, -150, 0); // Position

  // Blue directional light from the left
  directionalLight(0, 102, 255, // Color
                   1, 0, 0);    // The x-, y-, z-axis direction

  // Yellow spotlight from the front
  spotLight(255, 255, 109,  // Color
            0, 40, 200,     // Position
            0, -0.5, -0.5,  // Direction
            PI / 2, 2);     // Angle, concentration
}

//---- The SerialEvent function runs continuously in the background and
//---- stores new values whenever new data comes in on the serial port (USB)
void serialEvent(Serial myPort) {   
  serialString = myPort.readStringUntil(10); // Read until end of line character
  if (serialString != null) {     
    serialString = trim(serialString); 
//--- Read data as string, split on commas and store in an array: 
    String[] list = split(serialString, ',');
    data1 = float(list[0]);
    data2 = float(list[1]);

    println(data1, " , ", data2);
  }             //- end if()
}                             //- end function definition
