/* Processing code:
 * Example of animation playing back using Mouse position
 * to select index numbers in an array of images
 *--------------------------------------------------------------*/
 
 int mappedMouse;         // Variable for scaled (mapped) value
 int numFrames = 15;      // The number of frames in the animation
 PImage[] images = new PImage[numFrames];

  void setup() {
    frameRate(30);
    size(1280, 800);
    background(0, 0, 0);   // color (r, g, b)
    // The nf() command does number formatting, which will
    // ensure that the number is (in this case) 2 digits.
    for (int i = 0; i < numFrames; i++) {
      String imageName = "frame" + nf(i, 2) + ".jpg";
      images[i] = loadImage(imageName);
       }
    smooth();
   } 
 
// draw listens to serial port, calls serialEvent, draws   
  void draw() {  
    background(0, 0, 0);          // clear the screen
    fill(90, 100);                    // Set the gray value and alpha of the Rectangle 

    mappedMouse = int((map(mouseX, 0, 1280, 1, 14)));
    image(images[mappedMouse], 0, 0);
    println(mappedMouse);
    }            
