/*
 *  This is a program for enabling Processing to 
 *  "catch" serial data being sent to the Serial port 
 *  (by the Arduino.)
 *  First, find your serial port from the list in the console.
 *  Then enter that number in the "myPort" creation statement
 *  (It's the number in the square brackets.)
 *  And uncomment the statement with the "val" variable.
 **************************************************************/
 
import processing.serial.*; //--- import serial library
Serial myPort;              // Create Serial object, name it "myPort"
String serialString;        // variable for storing serial data
int val;                    // for storing number re-cast from string 

void setup() {   size(400, 400);    // Set size of canvas   
printArray(Serial.list());   // -Gives list of available ports   
//myPort = new Serial(this, Serial.list()[1], 9600); //-- Change to your port number
}

void draw(){   
//println(val);       //-- Write number to the interface output window
background(val);    //-- Set grey scale background color (0 - 255)
}                   //-- End of draw loop

//---- The SerialEvent function runs continuously in the background and
//---- stores new values whenever new data comes in on the serial port (USB)
void serialEvent(Serial myPort) {   
serialString = myPort.readStringUntil(10); // Read until end of line character
if (serialString != null) {     serialString = trim(serialString);      
val = int(serialString);     
  }                         //- end if()
}                           //- end function definition
