/**
 * multi-data_image
 * Image interactive -receiving data from 2 switches on Arduino 
 */
 
 import processing.serial.*;
 Serial myPort;
 int data1;
 int data2;
 String serialString;
PImage both_closed;  // Declare variable of type PImage
PImage both_open; 
PImage left;  
PImage right;  


void setup() {
  size(900, 1018);
  // image file must be in the data folder of the current sketch 
  // to load successfully
  both_closed = loadImage("both_closed.jpg");  // Load the image 
  both_open = loadImage("both_open.jpg");  // Load the image 
  left = loadImage("left.jpg");  // Load the image 
  right = loadImage("right.jpg");  // Load the image 
  println(Serial.list());   // Diagnostic: gives list of ports
  myPort = new Serial(this, Serial.list()[2], 9600); //-- Change to your port number
}

void draw() {
  if(data1 == 0 && data2 == 0) {
  image(both_open, 0, 0);
  } else if(data1 == 1 && data2 == 0){
   image(left, 0, 0);
  }else if(data1 == 0 && data2 == 1){
   image(right, 0, 0);
  }else {
   image(both_closed, 0, 0);
  }
}

//---- The SerialEvent function runs continuously in the background and
//---- stores new values whenever new data comes in on the serial port (USB)
void serialEvent(Serial myPort) {   
  serialString = myPort.readStringUntil(10); // Read until end of line character
  if (serialString != null) {     
    serialString = trim(serialString); 
//--- Read data as string, split on commas and store in an array: 
    String[] list = split(serialString, ',');
    data1 = int(list[0]);
    data2 = int(list[1]);

    println(data1, " , ", data2);
  }             //- end if()
}                             //- end function definition
