//--------    zcube_rotation
//    Maps an image to a surface of a cube and rotates it around a smaller cube
PImage img; // Variable for the image
int vSize = 240;


void setup() {
  size(1400, 900, P3D); // Set up the 3D canvas
  img = loadImage("crocodileFly.jpg"); // Load your image
  noStroke(); // No outlines for shapes
}

void draw() {
  background(100);
  translate(width/2, height/2, 0); // Move the origin to the center

  // Draw rotating cube
  pushMatrix(); // Isolate transformations
  stroke(0);
  rotateX(frameCount * 0.00); // Continuous rotation on the X-axis
  rotateY(frameCount * 0.03); // Continuous rotation on the Y-axis
  beginShape(QUADS);
  texture(img);
  // Front face with texture
  vertex(-vSize, -vSize, vSize, 0, 0);
  vertex(vSize, -vSize, vSize, img.width, 0);
  vertex(vSize, vSize, vSize, img.width, img.height);
  vertex(-vSize, vSize, vSize, 0, img.height);
  // Continue with other faces if needed...
  endShape();
  popMatrix(); // End of isolation

  // Draw smaller, stationary outlined cube
   stroke(255, 0, 50);
   translate(20, 30, 0); 
   rotateY(0.5);
   noFill();
   box(175);   // Draw smaller cube with 75 pixels size
}
