
// ------ Reads the state of a switch, lights an LED and sends Serial data ------------------
//       -Using variables to store pin numbers
//
//  > Wire an LED from Digital Pin 7 (pin 13 on the chip) thru a 330 ohm resistor to ground
//  > Wire a switch between Digital Pin 5 (pin 11 on the chip) and ground
//--------------------------------------------------------------------------------------------

boolean buttonState = 0;    // create variable for storing "state" of the button
int ledPin = 7;             // create variable for LED pin number
int buttonPin = 5;          // create variable for button pin number


void setup() {                      // Only do once at startup
  Serial.begin(9600);
  pinMode(ledPin, OUTPUT);          // initialize the digital pin as an output (for LED.)
  pinMode(buttonPin, INPUT_PULLUP); // initialize the digital pin as an input (for switch.)
}

void loop()  {                          // repeat forever
  buttonState = digitalRead(buttonPin); // "Read" the voltage present on the pin (check switch.)

  // If the pin wired to the button is low, the switch is closed
  if (buttonState == LOW) {
    digitalWrite(ledPin, HIGH);             // turn LED on
  // Serial.println(1);  // (uncomment this line to debug with the Serial Monitor)
    Serial.write(1);
  }
  // Otherwise, assume the switch is open.
  else {
    digitalWrite(ledPin, LOW);              // turn LED off
  // Serial.println(1);  // (uncomment this line to debug with the Serial Monitor)
    Serial.write(0);
  }

  delay(50);  
}


