/*   Serial communication with the Arduino 
 *   using any serial communication application
 * Setup: -Wire an LED from digital pin 7 thru 330ohm resistor to gnd
 *        - Connect a servo to +, gnd and digital pin 6 
 */
 #include <Servo.h>              // Arduino library for servo motors
  
 byte inByte;
 int servoPin1 = 6; // variable for servo pin number
 int servoPin2 = 9; // variable for servo pin number
 int servo1_Position;
 int servo2_Position;
 
 Servo myservo1;    // create servo object to control a servo 
 Servo myservo2;    // a maximum of eight servo objects can be created 

 void setup(){
    Serial.begin(9600);         // Begin serial communication
    myservo1.attach(servoPin1);   // attaches the servo on pin 9 to servo object    
    myservo2.attach(servoPin2);   // attaches the servo on pin 9 to servo object  
 }

void loop(){
    if (Serial.available() > 0){           // only if serial data's there
       inByte = Serial.read();             // read it, store in inByte                       
          if(inByte < 125){
          servo1_Position = map(inByte, 0, 124, 5, 170);
          }
          else if(inByte > 124){
          servo2_Position = map(inByte, 125, 255, 5, 170); 
          }
         myservo1.write(servo1_Position);   // tell servo to go to position
         myservo2.write(servo2_Position);   // tell servo to go to position
         }     
    }
