/*   Serial communication with the Arduino 
 *   using any serial communication application
 * Setup: -Wire an LED from digital pin 7 thru 330ohm resistor to gnd
 *        - Connect a servo to +, gnd and digital pin 6 
 */
 #include <Servo.h>              // Arduino library for servo motors
  
 byte inByte;
 int servoPin = 6; // variable for servo pin number
 int servoPosition;
 
 Servo myservo;  // create servo object to control a servo 
                // a maximum of eight servo objects can be created 

 void setup(){
    Serial.begin(9600);         // Begin serial communication
    myservo.attach(servoPin);   // attaches the servo on pin 9 to servo object    
 }

void loop(){
    if (Serial.available() > 0){           // only if serial data's there
       inByte = Serial.read();             // read it, store in inByte                       
       servoPosition = map(inByte, 0, 255, 5, 180);
         myservo.write(servoPosition);   // tell servo to go to position
         }     
    }
