/*   Serial communication with the Arduino 
 *   using any serial communication application
 * Setup: - Connect a servo to +, gnd and digital pin 6 
 *.        and second servo on pin 9
 */
 #include <Servo.h>              // Arduino library for servo motors
  
 byte inByte;
 int servoPin1 = 6; // variable for servo pin number
 int servoPin2 = 9; // variable for servo pin number
 int servo1_Position;
 int servo2_Position;
 
 Servo myservo1;    // create servo object to control a servo 
 Servo myservo2;    // a maximum of eight servo objects can be created 

 void setup(){
    Serial.begin(9600);         // Begin serial communication
    myservo1.attach(servoPin1);   // attaches the servo on pin 9 to servo object    
    myservo2.attach(servoPin2);   // attaches the servo on pin 9 to servo object  
 }

void loop(){
    if (Serial.available() > 0){           // only if serial data's there
       inByte = Serial.read();             // read it, store in inByte                       
       inByte = map(inByte, 0, 255, 5, 175);
       servo1_Position = inByte;
       servo2_Position = inByte; 
         myservo1.write(servo1_Position);   // tell servo to go to position
         myservo2.write(servo2_Position);   // tell servo to go to position
         }     
    }
