/* ----------------------  analog_Light_Sensor  -----------------------
 *   Make analog sensor: 
 *  _Either_ Solar cell between A5 (red wire) and Gnd (Blk wire)
 *    or:
 *   Voltage Divider Setup- a voltage divider connected to analog 5 :
 *   1) -Wire a photoresister between +5vdc and an empty row on the breadboard
 *   2) -Wire a 10k resistor between that same row on the breadboard to ground.
 *   3) -Jumper wire from that same row to analog pin 5 (A5)
 *   4) -Wire an LED thru a 330 ohm resistor from digital pin 7 to gnd
 *   -Note: This sketch introduces the map() function for scaling values
 *------------------------------------------------------------------------*/
int a_in;               // create variable for storing analog readings
int sensorPin = A5;      // variable for analog pin as A5

void setup() {
  Serial.begin(9600);            // start serial port at 9600 bps:
}

void loop() {
  // read sensor, store in variable, print
  a_in = analogRead(sensorPin);       // get 10 bit analog value
                                      // - 1st read the range you're getting in 
 a_in = constrain(a_in, 8, 230);          // raw data, then uncomment, constrain and map
 a_in = map(a_in, 8, 230, 0, 255); // scale it to 8 bits
//Serial.println(a_in);  //-- Uncomment and use for sending ASCII (and comment out following line.)
  Serial.write(a_in);  //-- Uncomment and use for sending numbers (and comment out preceding line.)
}