//------ Example of using the NYTimes API for Article search --------
//                     Loading JSON Data
//   by Daniel Shiffman.  
//   to retrieve JSON data via URL
//   This code requires entering a NYTimes developers key.
//    (freely available from:   https://developer.nytimes.com/)
//
//------------------------------------------------------------------
PFont myFont;

void setup() {
  size(600, 300);
   myFont = createFont("Arial", 36);
  textFont(myFont);
  textAlign(CENTER, CENTER);

  // The URL for the JSON data (replace "imperial" with "metric" for celsius)
  String apiKey = "Insert-your-API-Key-Here";
  String url = "http://api.nytimes.com/svc/search/v2/articlesearch.json";
  String query = "?q=processing&sort=newest";

  // Load the JSON document
  JSONObject json = loadJSONObject(url+query+"&api-key="+apiKey);
  String headline = json.getJSONObject("response").getJSONArray("docs").getJSONObject(0).getJSONObject("headline").getString("main");
  background(255);
  fill(0);
  text(headline,40,25,500,220);
}
