/**
 * BeatDetection
 * by Alex Miller
 * This sketch shows how to use the BeatDetector class to detect spikes
 * in sound energy that correspond to rhythmic beats. Change the sensitivity
 * value to adjust how much dampening the algorithm uses (higher values
 * make the algorithm less sensitive).
 *
 * Edit by Dana Moser 3/24
 */

import processing.sound.*;
PImage drums;

SoundFile sample;
BeatDetector beatDetector;

void setup() {
  size(450, 450);
  drums = loadImage("Drums.png");  // Load the image
  background(255);

  sample = new SoundFile(this, "drums.wav");
  sample.loop();
  
  beatDetector = new BeatDetector(this);
  beatDetector.input(sample);
  
  // The sensitivity determines how long the detector will wait after detecting
  // a beat to detect the next one.
  beatDetector.sensitivity(140);
}

void draw() {
  background(0);
  
  // If a beat is currently detected, light up the indicator
  if (beatDetector.isBeat()) {
    image(drums, 0, 0);
  } else {
    fill(0);
  }
}
